--
-- testDML.sql
--
-- This package shows how to reuse one context handle for multiple DML statements
CREATE OR REPLACE PACKAGE testDML 
IS
  v_saveCtx DBMS_XMLSave.ctxType := null;   -- a single static variable 
  PROCEDURE insertXML(p_xmlDoc IN CLOB);
  PROCEDURE updateXML(p_xmlDoc IN CLOB);
  PROCEDURE deleteXML(p_xmlDoc IN CLOB);
END;
/
 
CREATE OR REPLACE PACKAGE BODY testDML
IS 
  v_rows NUMBER;
  
  PROCEDURE insertXML(p_xmlDoc IN CLOB)
  IS
  BEGIN
    v_rows := DBMS_XMLSave.insertXML(v_saveCtx,p_xmlDoc);
  END insertXML;
   
  PROCEDURE updateXML(p_xmlDoc IN CLOB)
  IS
  BEGIN
    v_rows := DBMS_XMLSave.updateXML(v_saveCtx,p_xmlDoc);
  END updateXML;
  
  PROCEDURE deleteXML(p_xmlDoc IN CLOB)
  IS
  BEGIN
    v_rows := DBMS_XMLSave.deleteXML(v_saveCtx,p_xmlDoc);
  END deleteXML;
 
BEGIN
  v_saveCtx := DBMS_XMLSave.newContext('hr.employees'); -- create the context once
  DBMS_XMLSave.setKeyColumn(v_saveCtx, 'EMPLOYEE_ID');  -- set the key column name
END testDML;
/
